function Menu(dowhile, header){
  if (this instanceof Menu == false)
    return new Menu();
  
  this.arrow = LoadImage("Arrow.png");
  
  this.selection = 0;
  this.top_selection = 0;
  this.items = new Array();
  this.escape_function = function() {}
  
  if (header != undefined)
    this.header = header;
  if (header == undefined)
    this.header = "Command";
  
  if (dowhile != undefined)
    this.dowhile = dowhile;
  if (dowhile == undefined)
    this.dowhile = function() {}
}

Menu.prototype.addItem = function(name,link,color){
  var item = new Object();
  item.name = name;
  if (link != undefined)
    item.link = link;
  if (link == undefined)
    item.link = ExitGame;
  if (color != undefined)
    item.color = color;
  if (color == undefined)
    item.color = Normal;
    
  this.items[this.items.length] = item;
}

Menu.prototype.draw = function(x,y,l,h){
  this.shown_items = Math.floor((h - 8)  / 12);
  this.dowhile();
  Window(x,y,l,h,this.header);
  if (this.shown_items < this.items.length){
    Rectangle(x + 2 + l - 35, y + h + 1, 34, 10, CreateColor(64,64,63));
    Rectangle(x + 1 + l, y + 13, 8, h - 2, CreateColor(64,64,63));
    Rectangle(x + 3 + l, y + 19, 3, h - 16, CreateColor(0,0,0));
    Line(x + 2 + l - 36, y + h + 2, x + 2 + l - 36, y + h + 10, CreateColor(47, 40, 47));
    Line(x + 2 + l - 35, y + h + 11, x + 8 + l, y + h + 11, CreateColor(47, 40, 47));
    Line(x + 9 + l, y + h + 10, x + 9 + l, y + 13,CreateColor(47, 40, 47));
    Line(x + 8 + l, y + 12, x + 2 + l, y + 12,CreateColor(47, 40, 47));
    Line(x + 2 + l, y + 19, x + 2 + l, y + h + 2, CreateColor(80,80,80));
    Line(x + 6 + l, y + 19, x + 6 + l, y + h + 2, CreateColor(40,40,40));
    Line(x + 6 + l, y + h + 3, x +3 + l, y + h + 3, CreateColor(40,40,40));
    Line(x + 7 + l, y + 19, x + 7 + l, y + h + 3, CreateColor(200,200,200));
    Line(x + 7 + l, y + h + 4, x +3 + l, y + h + 4, CreateColor(200,200,200));
    Rectangle(x + 4 + l, y + 19 + Math.floor(this.top_selection * ((h - 16) / this.items.length)), 2, Math.floor(this.shown_items * (h - 16) / this.items.length) + 1, CreateColor(112,112,95));
  }
  for (var i = 0; i < this.shown_items; i++){
    if (i < this.items.length) {
      font.setColorMask(this.items[i + this.top_selection].color);
      font.drawText(x + 4, y + 4 + (i * 12), this.items[i + this.top_selection].name);
    }
  }
  this.arrow.blit(x - this.arrow.width + 2, y + 7 + (this.selection - this.top_selection) * 12);
}

Menu.prototype.execute = function(x,y,l,h){
  with (this){
  while (true) {
    draw(x,y,l,h);
    while (AreKeysLeft()) {
      switch (GetKey()) {
        case KEY_ENTER: {
          var item = items[selection];
          item.link();
          return;
        }
        case KEY_ESCAPE: {
          escape_function();
          return;
        }
        case KEY_DOWN: {
          if (selection < items.length - 1) {
            selection++;
            if (selection >= top_selection + shown_items)
              top_selection++;
          }
          break;
        }
        case KEY_UP: {
          if (selection > 0){
            selection--;
            if (selection < top_selection)
              top_selection--;
          }
          break;
        }
        case KEY_PAGEUP: {
          if (top_selection >= shown_items){
            selection -= shown_items;
            top_selection -= shown_items;
          }
          break;
        }
        case KEY_PAGEDOWN: {
          if (top_selection < items.length - shown_items - 1){
            selection+=shown_items;
            top_selection+=shown_items;
          }
        }
      }
    }
    FlipScreen();
  }
  }
}